/************************************************************************
 *
 * \file: mspin_demo_monitor.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: mySPIN - Demo application
 *
 * \author:
 *      Bui Le Thuan / RBVH/ENG2 / Thuan.BuiLe@vn.bosch.com
 *      Torsten Plate ICT-ADITG/SW2 tplate@de.adit-jv.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef MSPINDEMOMONITOR_H_
#define MSPINDEMOMONITOR_H_

#include <mspin_appl_if_adapter.h>
#include <signal.h>
#include <dlt/dlt.h>
#include <adit-system/adit_dlt.h>
#include <libusb-1.0/libusb.h>
#include <libudev.h>
#include <sys/prctl.h>
#include <mutex>
#include <condition_variable>
#include <chrono>
#include <mspin_demo_timer.h>
#include <mspin_demo_types.h>
#include <string.h>
#include <list>
#include "mspin_demo_testbed.h"

#ifndef MSPIN_IAP2_SUPPORT_DISABLED
#include <mspin_demo_iap2_connection.h>
#endif //#ifndef MSPIN_IAP2_SUPPORT_DISABLED

// FeatureDiscovery headers
#include <uspi/FeatureDiscoveryTypes.h>
#include <uspi/FeatureDiscovery.h>
#include <uspi/IFeatureDiscovery.h>

// DeviceDetector headers
// included to set the device mask to watch for (enum DD_EVENT_MASK)
#include <uspi/deviceDetector.h>
// necessary to retrieve device attributes like vendorId, productId, serial
#include <uspi/deviceManagement.h>

using namespace adit::uspi;


class DeviceMonitor : public Singleton<DeviceMonitor>, IFeatureDiscoveryCb
{
private:

    static bool m_EAPSessionStarted;
    static bool m_iOSDeviceReady;

    // use in handle monitor thread
    std::list<usb_device> m_UsbDeviceList;
    std::shared_ptr<DiscoveredDeviceUsb> pSwitchedUsbDevice;

    pthread_t m_MonitorThread;
    Testbed* m_testbed_instance;
    // -------

#ifndef MSPIN_IAP2_SUPPORT_DISABLED
    Iap2Connection m_iAP2_Connection;
    static timer_t m_iAP2TimerId;
    static sem_t m_iAP2ConnLock;
#endif //#ifndef MSPIN_IAP2_SUPPORT_DISABLED

    mspin_demo_monitor_context_t* m_SharedMonCtx;
    FeatureDiscovery* discoverer;

public:

    DeviceMonitor();
    ~DeviceMonitor();

    void setMonitorContext(mspin_demo_monitor_context_t* pInputMonCtx);
    mspin_demo_monitor_context_t* getMonitorContext();
    void setSwitchedUsbDevice(std::shared_ptr<DiscoveredDeviceUsb> pInUsbDevice);
    std::shared_ptr<DiscoveredDeviceUsb> getSwitchedUsbDevice();

    /*
     * handling list of Usb Device
     */
    usb_device getFirstItemOfUsbDeviceList();
    void removeFirstItemOfUsbDeviceList();
    bool addItemIntoUsbDeviceList(usb_device inUsbDevice);
    uint32_t getSizeOfUsbDeviceList();
    void printUsbDeviceList();
    void resetUsbDeviceList();

    /*
     * using for Testbed mode
     */
    void setTestbedInstance(Testbed* instance);
    Testbed* getTestbedInstance();

    /*
     * usb monitor
     */
    bool isIOSDevice(uint32_t vendorId, uint32_t productId);
    bool isIOSDeviceOnOTGPort(std::string devPath);

    bool preselectDevice(uint32_t vendorId, uint32_t productId, std::string serial, std::string devPath);
    bool start_monitor(U32 inDemoTimeout);
    void stop_monitor();
    void handle_found_device(DeviceMonitor* pArg, std::shared_ptr<DiscoveredDevice> inDevice);

    // callbacks received from FeatureDiscovery
    DiscoveryError foundCb(std::shared_ptr<DiscoveredDevice> inDevice);
    DiscoveryError lostCb(std::shared_ptr<DiscoveredDevice> inDevice);
    DiscoveryError switchedCb(std::shared_ptr<DiscoveredDevice> inDevice);
    DiscoveryError changedCb(std::shared_ptr<DiscoveredDevice> inDevice);
    DiscoveryError errorCb(DiscoveryError inErrorCode);

    /*
     * iAP2 monitor
     */
#ifndef MSPIN_IAP2_SUPPORT_DISABLED
    static void iAP2DeviceReady_CB(void *pToken, bool ready);
    static void iAP2DeviceDisconnected_CB(void *pToken);
    static void EAPSessionStart_CB(void *pToken);
    static void EAPSessionStop_CB(void *pToken);
    static void connectTimeoutHandler_CB(int sig, siginfo_t *si, void *uc);
    MSPIN_ERROR connectIAP2(mspin_demo_connectionParameter_t *pDevice);
    void disconnectIAP2();
#endif //#ifndef MSPIN_IAP2_SUPPORT_DISABLED

    /*
     * wifi monitor
     */
    static void OnUDPBroadcastEnd_CB(MSPIN_UDP_BROADCAST_END_REASON reason, void* context);
    static bool OnAcceptIncomingConnection_CB(S32 connectionID, const U8* ipAddr, void* context);
    static void OnConnectionClosed_CB(S32 connectionID, MSPIN_TCP_CONNECTION_END_REASON reason, const U8* ipAddr, void* context);

    /*
     * get state
     */
    static std::string getRunState(mspin_demo_run_state_t state);
    static std::string getSwitchRunState(mspin_demo_switch_run_state_t state);

};

#endif /* MSPINDEMOMONITOR_H_ */
